#ifndef ZMODELER_STRUCT_OBJECTSET_H_INCLUDED
#define ZMODELER_STRUCT_OBJECTSET_H_INCLUDED

////////////////////////////////////////////////////////
//      S  E  T    OF  OBJECTS
////////////////////////////////////////////////////////
class DllExport tObjectSet
{
public:
//------------------------
//  data members
  long      ObjAmount;
  tObject   DummyObject;
  tObject    *ObjSet;

  long      ObjOperands[MAX_OBJ_OPERANDS];// Parameters for operations...

public:
//------------------------
//  construction/deconstruction
  tObjectSet();
  ~tObjectSet();

//------------------------
//  functions
  tPOINT  GetCenterPoint();    //returns center of scene bounding box
  //verifies whether an object with supplied name already exists in the scene
  BOOL  ExistObjectName(CString Pattern);
  //returns sequental name for supplied object name (it either the same name as
  //supplied or the name with sequental number in square brackets: "box[1]"
  char*  GetSequentalName(char* pattern);

  //puts scene bounding box values to supplied tPOINT objects.
  void GetMaxMinPoints(tPOINT *max, tPOINT *min);

  //adds object to the set. The supplied pointer is no longer used
  //and usually should be deleted: {AddObject(pObj); delete pObj;}
  void AddObject(tObject *obj);

  //Inserts an object in specified position. Position must not exceed
  //amount of objects in the scene (but can match this amount to add
  //the last object). Supplied pointer is no longer used and should be
  //deleted.
  void InsertObject(  tObject *obj, long position);

  //detaches single object from the set and returns pointer to it;
  //see also: DeleteObjectFromSet(long);
  tObject* RemoveObjectFromSet(long index);
  
  //returns a copy of specified object
  tObject* GetObjectCopy(long index);

  //removes object from the set. See also: RemoveObjectFromSet(long);
  void DeleteObjectFromSet(long index);
  //deletes vertices (marked or selected depend on CurrentState.IsSelectedMode())
  //from marked objects.
  void DeleteVerticesFromObjects(BOOL NeedDeleteFaces);
  //deletes objects that are in custom state (marked, selected).
  void DeleteObjects(BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden);
  //removes unused vertices from objetcs, deletes duplicate
  //and invalid faces. Returns TRUE if any cleanup was performed; It will put the
  //index of empty object into supplied parameter. Empty object is the object who's
  //all faces and vertices were deleted. This object shold be deleted.
  BOOL CleanUpObjects(long* MarkedIndex);
  //Creates a single copy of object(s) that are in custom state (marked, selected).
  //It can delete original object(s) from set as well. Returns TRUE on success.
  BOOL CopyObjects(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
            BOOL DeleteOriginal);
  //Detaches faces (either marked, selected) from marked obejct. It can either
  //delete detached faces from original objects or leave them there.
  //Returns TRUE on success.
  BOOL Detach(BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
        BOOL DeleteOriginal);


  BOOL Selected(long index);  //tells whether the custom face has Z3D_FLAG_SELECTED in nFlags
  BOOL Marked(long index);  //tells whether the custom face has Z3D_FLAG_MARKED in nFlags
  BOOL Disabled(long index);  //tells whether the custom face has Z3D_FLAG_DISABLED in nFlags
  BOOL Hidden(long index);  //tells whether the custom face has Z3D_FLAG_HIDDEN in nFlags
  void Select(long index);  //selects one face
  void UnSelect(long index);  //deselects one face
  void Mark(long index);    //marks one face
  void UnMark(long index);  //unmarks one face
  void Disable(long index);  //disables one face
  void Enable(long index);  //enables one face
  void Hide(long index);    //hides one face
  void UnHide(long index);  //un-hides one face
  
  void ToHasFlagSetFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
              BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
              BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void ToHasFlagChangeFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
                BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
                BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void ToAllChangeFlag(  BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void SelectAll();      //selects all faces in Table
  void UnSelectAll();      //deselects all faces in Table
  void MarkAll();        //marks all faces in Table
  void UnMarkAll();      //unmarks all faces in Table
  void DisableAll();      //disables all faces in Table
  void EnableAll();      //enables all faces in Table
  void HideAll();        //hides all faces in Table
  void UnHideAll();      //unhides all faces in Table

  void DeleteSet();      //deletes ALL objects from set.
  void DeleteMapperObject();  //Deletes mapper object (UVMapperDATA)
  //returns an index of material that UVMapperDATA uses.
  long GetMapperObjectMaterialIndex();
  //Either creates new UVMapperDATA or resets current mapping. Creation of mapping
  //object depends on View and FaceMap mode.
  void UVMapping(BOOL AssignMode, ViewMode View, BOOL FaceMap);
  //updates mapping, assuming that supplied mapindex is the index of Mapping Object.
  void UpdateMapping(long mapindex);

  //Draws the objects on supplied CDC object, using GlobalResoures.
  virtual void Draw(  CDC* pDC, z3dViewDescriptor* pView, BOOL  DrawMarked);
  //Returns TRUE if cover-factor of any element have been changed with covering it
  //by loc parameter. It can be activation by mouse cursor for example.
  virtual BOOL Cover(  POINT *loc, z3dViewDescriptor* pView, BOOL Multy, long CoverRadius);
  tObject& Get(int index);//safe access to ObjSet members;
};


#endif

